// PageDevice.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageDevice.h"
#include "Include/CommonFun.h"
//#include"DecCtrlClient.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "SearchNVS.h"

// CPageDevice Ի

IMPLEMENT_DYNAMIC(CPageDevice, CDialog)

CPageDevice::CPageDevice(CWnd* pParent /*=NULL*/)
	: CDialog(CPageDevice::IDD, pParent)
{
	
}

CPageDevice::~CPageDevice()
{
}

void CPageDevice::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_DEVICE, m_LstDevice);
	DDX_Control(pDX, IDC_EDIT_SUM, m_edtDeviceNum);
	DDX_Control(pDX, IDC_EDT_CLUSTER_NAME, m_edtClusterName);
	DDX_Control(pDX, IDC_EDT_ALIAS, m_edtAlias);
	DDX_Control(pDX, IDC_COMBO_SEEK_TYPE, m_CbbSeekType);
	DDX_Control(pDX, IDC_COMBO_SEEK_DEVICE, m_cbbDevice);
	DDX_Control(pDX, IDC_EDT_CLUSTER_ID, m_dlgClusterId);
}


BEGIN_MESSAGE_MAP(CPageDevice, CDialog)
	ON_BN_CLICKED(IDC_BTN_DISMISS, &CPageDevice::OnBnClickedBtnDismiss)
	ON_BN_CLICKED(IDC_BTN_ALIAS, &CPageDevice::OnBnClickedBtnAlias)
	ON_BN_CLICKED(IDC_BTN_ADD, &CPageDevice::OnBnClickedBtnAdd)
	ON_BN_CLICKED(IDC_BTN_DISCOVERY, &CPageDevice::OnBnClickedBtnDiscovery)
	ON_BN_CLICKED(IDC_BTN_CLEAR, &CPageDevice::OnBnClickedBtnClear)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_DEVICE, &CPageDevice::OnLvnItemchangedListDevice)
END_MESSAGE_MAP()

void CPageDevice::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STC_CLUSTER_NAME, GetText(IDS_CLUSTER_ID));
	SetDlgItemText(IDC_STC_ALIAS, GetText(IDS_CLUSTER_ALIAS));
	SetDlgItemText(IDC_STC_SUM, GetText(IDS_DEVICE_SUM));
	SetDlgItemText(IDC_BTN_DISMISS, GetText(IDS_DEMERGE));

}
// CPageDevice Ϣ

BOOL CPageDevice:: Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	int iIndex = 0;
	
	
	m_LstDevice.InsertColumn(iIndex++, "IP", LVCFMT_LEFT,90);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SERVER_PORT), LVCFMT_LEFT, 80);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_CFG_CLUSTER_DEVICEINFO_ID), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SETTING_MAC), LVCFMT_LEFT,120);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SETTING_MASK), LVCFMT_LEFT,90);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SETTING_GATE), LVCFMT_LEFT,90);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SETTING_DNS), LVCFMT_LEFT,90);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_SETTING_SIPVIDEOCHANNEL), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_CLIENT_PORT), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_DEV_PLAT_TYPE), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_HTTP_PORT), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_PRODUCT_MODEL), LVCFMT_LEFT, 120);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_FACTORY_ID), LVCFMT_LEFT, 160);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_KERNEL_VERSION), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_OCX_VERSION), LVCFMT_LEFT, 90);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_CFG_CLUSTER_DEVICEINFO_ALIAS), LVCFMT_LEFT, 60);
	m_LstDevice.InsertColumn(iIndex++, GetText(IDS_CFG_CLUSTER_DEVICEINFO_COUNT), LVCFMT_LEFT, 90);

	iIndex = 0;
	m_LstDevice.SetSortType(iIndex,SORT_TYPE_IP);

	m_LstDevice.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);

	m_CbbSeekType.AddString("IP");
	//m_CbbSeekType.AddString("DNS");
	//m_CbbSeekType.AddString("DSM");
	m_CbbSeekType.SetCurSel(0);


	m_cbbDevice.AddString("IPC");
	m_cbbDevice.AddString("NVD");
	m_cbbDevice.SetCurSel(0);
	
	SetDlgItemText(IDC_EDT_USERBANE, "Admin");
	SetDlgItemText(IDC_EDT_PASSWD, "1111");

	InitProductModel();
	return TRUE;
}

void CPageDevice::Make_M7_PM(int _iPM, char* _pcID, char* _pcID1)
{
	CString strPM;
	strPM.Format("%s/%s", _pcID, _pcID1);
	m_mapProductModel.insert(pair<int, char*>(_iPM, (LPSTR)(LPCTSTR)strPM));
}

void CPageDevice::InitProductModel()
{
#undef  INSERT_PRODUCTMODEL
#define INSERT_PRODUCTMODEL(id)				m_mapProductModel.insert(pair<int,char*>(id, #id));
#define INSERT_PRODUCTMODEL_M7(id, idEx)     Make_M7_PM(id, #id, #idEx)

	INSERT_PRODUCTMODEL(TC_NVSS);
	INSERT_PRODUCTMODEL(TC_NS621S);
	INSERT_PRODUCTMODEL(TC_NS621S_USB);
	INSERT_PRODUCTMODEL(TC_NS224S);
	INSERT_PRODUCTMODEL(TC_NC621S);
	INSERT_PRODUCTMODEL(TC_NC8000S);
	INSERT_PRODUCTMODEL(TC_NC8001S);
	INSERT_PRODUCTMODEL(TC_NC8100S);
	INSERT_PRODUCTMODEL(TC_NC8101S);
	INSERT_PRODUCTMODEL(TC_NC8200S);
	INSERT_PRODUCTMODEL(TC_NC8700S2);
	INSERT_PRODUCTMODEL(TC_NC8250);
	INSERT_PRODUCTMODEL(TC_NC9010S2_MP);
	INSERT_PRODUCTMODEL(TC_NC9000S2_2MP);
	INSERT_PRODUCTMODEL(TC_NC9010N1_2MP);
	INSERT_PRODUCTMODEL(TC_NC9000S3_3MP);
	INSERT_PRODUCTMODEL(TC_NH9106N1_2MPIR);
	//INSERT_PRODUCTMODEL(TC_NS921_N1_2MP);
	INSERT_PRODUCTMODEL(TC_CC9118_MP_E);
	INSERT_PRODUCTMODEL(TC_NC9100S3_3MP_IR30);
	INSERT_PRODUCTMODEL(TC_NT9054S2_MPIR);
	INSERT_PRODUCTMODEL(TC_NS621S2);
	INSERT_PRODUCTMODEL(TC_NS324S2);
	INSERT_PRODUCTMODEL(TC_NS628S2);
	INSERT_PRODUCTMODEL(TC_NC9010I_2MP);
	INSERT_PRODUCTMODEL(TC_NC9000I_5MP);
	INSERT_PRODUCTMODEL(TC_2816AN_SH);
	INSERT_PRODUCTMODEL(TC_2808AN_S_3511);
	INSERT_PRODUCTMODEL(TC_2816AN_SD);
	INSERT_PRODUCTMODEL(TC_2816AN_SD_E);
	INSERT_PRODUCTMODEL(TC_2808AN_S_3515);
	INSERT_PRODUCTMODEL(TC_2804AN_MX);
	INSERT_PRODUCTMODEL(TC_2816AN_S);
	INSERT_PRODUCTMODEL(TC_H802BHX_T);
	INSERT_PRODUCTMODEL(TC_2832AN_SS);
	INSERT_PRODUCTMODEL(TC_1002S2_3C);
	INSERT_PRODUCTMODEL(TC_2802AN_SDI);
	INSERT_PRODUCTMODEL(TC_H908NC_H_V50);
	INSERT_PRODUCTMODEL(TC_ND921S2_MP);
	INSERT_PRODUCTMODEL(TC_ND921S2_2MP);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L_H);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_H);
	INSERT_PRODUCTMODEL(TC_2804AN_SA);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L);
	INSERT_PRODUCTMODEL(TC_2800AN_SF);

	INSERT_PRODUCTMODEL(TC_2804AN_SDI);

	INSERT_PRODUCTMODEL(TC_FS0013ERS_HD);         // ޸ĸ岥
	INSERT_PRODUCTMODEL(TC_NC9100S3E_MP_IR30);    //
	INSERT_PRODUCTMODEL(TC_NC9000S3_2MP_E);       // 200W 콨Ŀ
	INSERT_PRODUCTMODEL(TC_NC9200S3_MP_E_IR15);   // ֮ǰproductmodel 0x0059,Ŀ
	INSERT_PRODUCTMODEL(TC_NC9100S1_MP_IR);       // 0xC0046,Ŀ
	INSERT_PRODUCTMODEL(TC_NS921S3_HD_V1);        // 0xC0056,Ŀ ֮ǰTC_NS921_N1_2MP豸Ϊ˿
	INSERT_PRODUCTMODEL(TC_NC9000S3_MP_E);        // ѧĿ
	INSERT_PRODUCTMODEL(TC_2804AN_SQ);
	INSERT_PRODUCTMODEL(TC_2808AN_SF_L);

	INSERT_PRODUCTMODEL(TC_ND921S2_SDI)
		INSERT_PRODUCTMODEL(TC_21X_R2);
	INSERT_PRODUCTMODEL(TC_21X_R3);
	INSERT_PRODUCTMODEL(TC_21X_R5);

	//  
	INSERT_PRODUCTMODEL(TC_NH9206S3_2MP_IVS);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_MP);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_MP_IR);

	//add by bo 20140725
	INSERT_PRODUCTMODEL(TC_2804AN_SR_L);
	INSERT_PRODUCTMODEL(TC_H804I_HD_BP);
	INSERT_PRODUCTMODEL(TC_H904B_HD_V6_X);
	INSERT_PRODUCTMODEL(TC_H908NC_HD);
	INSERT_PRODUCTMODEL(TC_NC9100S3E_2MP_IR30);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_2MP);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_2MP_IR);
	INSERT_PRODUCTMODEL(TC_NC921S3E_MP_HD_C);
	INSERT_PRODUCTMODEL(TC_NH9406S3E_MPIR);
	INSERT_PRODUCTMODEL(TC_NH9406S3E_2MPIR);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_2MP_E);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_MP_E);								
	INSERT_PRODUCTMODEL(TC_218_T5);
	INSERT_PRODUCTMODEL(TC_218_T3H);
	INSERT_PRODUCTMODEL(TC_217_T5);
	INSERT_PRODUCTMODEL(TC_217_T3H);
	INSERT_PRODUCTMODEL(TC_NH9X06S6_XMPIR_A);
	INSERT_PRODUCTMODEL(TC_NH9X06S6_XMPIR_T);														
	INSERT_PRODUCTMODEL(TC_H804BE_HD);				
	INSERT_PRODUCTMODEL(TC_H804N_HD);						
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L_H);		
	INSERT_PRODUCTMODEL(TC_2800AN_SF_H);				
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L);			
	INSERT_PRODUCTMODEL(TC_2800AN_SF);		
	INSERT_PRODUCTMODEL(TC_H804BE_P);	
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S2);
	INSERT_PRODUCTMODEL(TC_2804AN_M);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S1);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S2);
	INSERT_PRODUCTMODEL(TC_2800AN_R8_S2);
	INSERT_PRODUCTMODEL(TC_H804N_HD_P);
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S2_V2_0);
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S4);
	INSERT_PRODUCTMODEL(TC_2800AN_R32_S4);
	INSERT_PRODUCTMODEL(TC_2816AN_SR_V2_0);
	INSERT_PRODUCTMODEL(TC_2832AN_SR_V2_0);							
	INSERT_PRODUCTMODEL(TC_2864AN_SR);
	INSERT_PRODUCTMODEL(TC_7816W);

	//add by bo 20150713
	INSERT_PRODUCTMODEL(TC_NH9206N1_MPIR_IVS);
	INSERT_PRODUCTMODEL(TC_NS324S2);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_5MP_UE);
	INSERT_PRODUCTMODEL(TC_NC9001S3E_3MP_E);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_3MP_EI_IR);
	INSERT_PRODUCTMODEL(TC_NH9806S6_3MPIR_I);
	INSERT_PRODUCTMODEL(TC_CC9033_3MP);
	INSERT_PRODUCTMODEL(TC_NC9401S3E_4MP_I5_E);
	INSERT_PRODUCTMODEL(TC_NC9401S3E_4MP_I_E);
	INSERT_PRODUCTMODEL(TC_NC9001S3E_2MP_ES);
	INSERT_PRODUCTMODEL(TC_NH9904S6_2MP);
	INSERT_PRODUCTMODEL(TC_NH9806S6_2MPIR_S_A);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_2MP_D);
	INSERT_PRODUCTMODEL(TC_217_T2);
	INSERT_PRODUCTMODEL(TC_217_T3);
	INSERT_PRODUCTMODEL(TC_237_5MPH);
	INSERT_PRODUCTMODEL(TC_238_5MPH);
	INSERT_PRODUCTMODEL(TC_227_2MP_S_Z);
	INSERT_PRODUCTMODEL(TC_217_1MP_S);
	INSERT_PRODUCTMODEL(TC_T800GE);
	INSERT_PRODUCTMODEL(TC_H904BIX_HD_I);
	INSERT_PRODUCTMODEL(TC_T238_5MP_S_Z);
	INSERT_PRODUCTMODEL(TC_T238_6MP);
	INSERT_PRODUCTMODEL(TC_T237_6MP);
	INSERT_PRODUCTMODEL(TC_T238_6MP_B);
	INSERT_PRODUCTMODEL(TC_NR2160M7_E16);
	INSERT_PRODUCTMODEL(TC_NR2080M7_E16);
	INSERT_PRODUCTMODEL(TC_NR2080M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2020M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2080M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_S4);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S4);	
	INSERT_PRODUCTMODEL(TC_NR2020M7_S2);

	//Add 2015 12 31
	INSERT_PRODUCTMODEL(TC_NC9400S3E_MP_C_IR30);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_2MP_E_I3);
	INSERT_PRODUCTMODEL(TC_T237_2MP_S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_4MP_EI_IR30);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_4MP_EI_IR30_M);
	INSERT_PRODUCTMODEL(TC_NC9101S3E_2MP_EI_IRW30_S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_2MP_EI_IR30);
	INSERT_PRODUCTMODEL(TC_NC9011S3E_3MP);
	INSERT_PRODUCTMODEL(TC_NC9501S3E_2MP_I3S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_2MP_I3S);
	INSERT_PRODUCTMODEL(TC_NH9806S6_2MPIR_S_T);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S1_V2_0);
	INSERT_PRODUCTMODEL(TC_T237_7MP);
	INSERT_PRODUCTMODEL(TC_T238_7MP);
	INSERT_PRODUCTMODEL(TC_T237_2MP_S);
	INSERT_PRODUCTMODEL(TC_NH9406S6_MPIR_S);
	INSERT_PRODUCTMODEL(TC_NH9606S6_2MPIR_S);
	INSERT_PRODUCTMODEL(TC_T1);
	INSERT_PRODUCTMODEL(TC_NC9101S3E_2MP_ES);
	INSERT_PRODUCTMODEL(T227_2MP_S_Z_V2);
	INSERT_PRODUCTMODEL(TC_H804N_HD_4SATA);
	INSERT_PRODUCTMODEL(TC_2800AN_P4_S1);
	INSERT_PRODUCTMODEL(TC_2800AN_P4_S2);
	INSERT_PRODUCTMODEL(TC_2800AN_P16_S4);
	INSERT_PRODUCTMODEL(TC_2816AN_SR_DZ15543);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S1);
	INSERT_PRODUCTMODEL(TC_NR2010M7_S1);
	INSERT_PRODUCTMODEL(TC_H802_XK);
	INSERT_PRODUCTMODEL(TC_H904BIX_N);
	INSERT_PRODUCTMODEL(TC_ND922S4_C);
	INSERT_PRODUCTMODEL(TC_ND921S5);
	INSERT_PRODUCTMODEL(TC_NX212_C);
}

CString CPageDevice::GetProductModel(int _iModel)
{
	CString strModel;
	map<int,char*>::iterator it = m_mapProductModel.find(_iModel);
	if (it == m_mapProductModel.end())
	{
		if (0xFFFF != _iModel)
		{
			strModel.Format(_T("undefined-%#x"),_iModel);
		}
	}
	else
	{
		strModel.Format(_T("%s"),it->second);
	}

	return strModel;
}

LRESULT CPageDevice::OnMainMsg( WPARAM _wParam,LPARAM _lParam )
{
	int iType = LOWORD(_wParam);
	int iID = (int)_lParam;
	switch(iType)
	{
	case DEC_WCM_SEARCH_NVD:
			UpdateDeviceInfo();
	}
	return 0;
}
void CPageDevice::OnBnClickedBtnDismiss()
{
	if(m_lLogonID < 0)
	{
		return;
	}
	ClusterMerage tClusterMerage = {0};
	DEC_ClientSetClusterConfig(m_lLogonID, CLUSTER_DEMERAGE, NULL, 0);
}


void CPageDevice::UpdateDeviceInfo()
{
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}
	int iRet = 0;
	int iResultSize = 0;
	ClusterInfo tClusterInfo = {0};
	tClusterInfo.iSize = sizeof(ClusterInfo);
	iRet = DEC_ClientGetClusterConfig(m_lLogonID, CLUSTER_CLUSTERINFO, &tClusterInfo, sizeof(ClusterInfo), &iResultSize);
	if (iRet < 0)
	{
		return ;
	}

	ClusterAlias tClusterAlias = {0};
	tClusterAlias.iSize = sizeof(ClusterAlias);
	iRet = DEC_ClientGetClusterConfig(m_lLogonID, CLUSTER_ALIAS, &tClusterAlias, sizeof(ClusterAlias), &iResultSize);
	if (iRet < 0)
	{
		return ;
	}
 	SetDlgItemInt(IDC_EDIT_SUM, tClusterInfo.iDevNum);
	SetDlgItemText(IDC_EDT_CLUSTER_NAME, tClusterInfo.cClusterId);
	SetDlgItemText(IDC_EDT_ALIAS, tClusterAlias.cAlias);
}
void CPageDevice::OnBnClickedBtnAlias()
{
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}
	int iRet = 0;
	ClusterAlias tClusterAlias = {0};
	tClusterAlias.iSize = sizeof(ClusterAlias);
	CString cstext;
	m_edtAlias.GetWindowText(cstext);
	strncpy(tClusterAlias.cAlias, cstext,sizeof(tClusterAlias.cAlias) - 1);
	DEC_ClientSetClusterConfig(m_lLogonID, CLUSTER_ALIAS, &tClusterAlias, sizeof(ClusterAlias));
}
void CPageDevice::OnBnClickedBtnAdd()
{
	// TODO: Add your control notification handler code here
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}

	POSITION pos = m_LstDevice.GetFirstSelectedItemPosition();
	if (pos == NULL)
	{
		return;
	}
	int nItem = m_LstDevice.GetNextSelectedItem(pos);
#pragma warning(disable : 4996)
	CString strIP = m_LstDevice.GetItemText(nItem, 0);
	CString strPort = m_LstDevice.GetItemText(nItem, 1);
	CString strClusterId = "";
	GetDlgItemText(IDC_EDT_CLUSTER_ID,strClusterId);
	CString strUsername;
	CString strPasswd;
	GetDlgItemText(IDC_EDT_USERBANE, strUsername);
	GetDlgItemText(IDC_EDT_PASSWD, strPasswd);
	
	ClusterMerage tClusterMerage = {0};
	tClusterMerage.iSize = sizeof(ClusterMerage);
	strncpy(tClusterMerage.cIP, strIP.GetBuffer(),sizeof(tClusterMerage.cIP) - 1);
	tClusterMerage.iPort = atoi(strPort.GetBuffer());
	strncpy(tClusterMerage.cUserName, strUsername.GetBuffer(),sizeof(tClusterMerage.cUserName) - 1);
	strncpy(tClusterMerage.cPassword, strPasswd.GetBuffer(),sizeof(tClusterMerage.cPassword) - 1);
	strncpy(tClusterMerage.cClusterId, strClusterId.GetBuffer(),sizeof(tClusterMerage.cClusterId) - 1);
	DEC_ClientSetClusterConfig(m_lLogonID, CLUSTER_MERAGE, &tClusterMerage, sizeof(ClusterMerage));

}

void CPageDevice::OnBnClickedBtnDiscovery()
{
	// TODO: Add your control notification handler code here
	if(m_lLogonID < 0)
	{
		m_lLogonID = 0;
	}
	int iRet = 0;
	ClusterSearchParam tClusterSearchParam = {0};
	tClusterSearchParam.iSize = sizeof(ClusterSearchParam);
	tClusterSearchParam.iSeekDevice = m_cbbDevice.GetCurSel() +1;
	tClusterSearchParam.iSeekType = m_CbbSeekType.GetCurSel();

	DEC_ClientSetClusterConfig(m_lLogonID, CLUSTER_SEARCH, &tClusterSearchParam, sizeof(ClusterSearchParam));
}

void CPageDevice::OnMainNotify( _MAIN_NOTIFY_DATA* _pData )
{
	if (_pData->m_iMsg != DEC_WCM_SEARCH_NVD && _pData->m_iMsg != DEC_WCM_SEARCH_IPC)
	{
		return;
	}

	ClusterSearchResult tClusterSearchResult = _pData->tParam.tClusterSearchResult;


	vector<ClusterSearchResult*>::iterator it = m_vecSearchResult.begin();
	for (; it != m_vecSearchResult.end(); ++it)
	{
		ClusterSearchResult* pResult = *it;
		if (pResult == NULL)
		{
			m_vecSearchResult.erase(it);
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::PushStreamData] failed");
			return ;
		}

		if (memcmp(pResult, &tClusterSearchResult, sizeof(ClusterSearchResult)) == 0)
		{
			return;
		}
	}

	int iCount = m_LstDevice.GetItemCount();
	int iIndex = 0;
	CString cstext;
	m_LstDevice.InsertItem(iCount, "");
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cIP);
	cstext.Format("%d", tClusterSearchResult.iServerPort);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cClusterId);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cMac);	
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cMask);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cGateWay);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cDNS);
	cstext.Format("%d", tClusterSearchResult.iChannelNum);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	cstext.Format("%d", tClusterSearchResult.iClientPort);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	cstext.Format("%d", tClusterSearchResult.iDeviceType);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	cstext.Format("%d", tClusterSearchResult.iHttpPort);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	//cstext.Format("%d", tClusterSearchResult.iProductModel);
	cstext = GetProductModel((tClusterSearchResult.iProductModel)&0xffff);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cFactoryID);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cKernelVersion);
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cOcxVersion);
	
	m_LstDevice.SetItemText(iCount, iIndex++, tClusterSearchResult.cClusterAlias);
	cstext.Format("%d", tClusterSearchResult.iDevNum);
	m_LstDevice.SetItemText(iCount, iIndex++, cstext);
	ClusterSearchResult* tClusterSearchResultTmp = (ClusterSearchResult*)malloc(sizeof(ClusterSearchResult));
	*tClusterSearchResultTmp = tClusterSearchResult;
	m_vecSearchResult.push_back(tClusterSearchResultTmp);
}

void CPageDevice::OnBnClickedBtnClear()
{
	// TODO: Add your control notification handler code here
	vector<ClusterSearchResult*>::iterator it = m_vecSearchResult.begin();
	while(it != m_vecSearchResult.end())
	{
		if (*it != NULL)
		{
			free(*it);
		}
		m_vecSearchResult.erase(it);
		it = m_vecSearchResult.begin();
	}
	m_LstDevice.DeleteAllItems();
}

BOOL CPageDevice::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	//Initialize(NULL);
	UpdateDeviceInfo();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPageDevice::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_MERAGE_CLUSTER:
		{
			MessageBox(GetText(IDS_CFG_CLUSTER_MERGE_SUCCESS),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
	case DEC_PARACHANGE_DEMERAGE_CLUSTER:
		{
			MessageBox(GetText(IDS_CFG_CLUSTER_DEMERGE_SUCCESS),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
		break;
	}
}


void CPageDevice::OnLvnItemchangedListDevice(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	POSITION pos = m_LstDevice.GetFirstSelectedItemPosition();
	int nItem = m_LstDevice.GetNextSelectedItem(pos);
	CString strClusterId = m_LstDevice.GetItemText(nItem, 2);
	SetDlgItemText(IDC_EDT_CLUSTER_ID,strClusterId);
	*pResult = 0;
}
